// src/app/article.service.ts
import { Injectable } from '@angular/core';
import { Observable, of } from 'rxjs';
import * as jsonData from '../assets/json/articles.json';

//import { HttpClient } from '@angular/common/http';
//import { Observable } from 'rxjs';
//import { ConfigService } from './config.service';

@Injectable({
  providedIn: 'root'
})

// For local JSON data
export class ArticleService {
  private data: any = (jsonData as any).default || jsonData;

  getArticles(): Observable<any> {
    console.log('Data', this.data);
    return of(this.data);
  }

  getArticle(contentId: string): Observable<any> {
    let article = null;
    if (Array.isArray(this.data)) {
      article = this.data.find((item: any) => item.contentId === contentId);
    }
    console.log('Data specific', article);
    return of(article);
  }
}

/*
// To connect with DX JSON content
export class ArticleService {
  private dxHost: string;
  private apiUrl: string;

  constructor(private http: HttpClient, private configService: ConfigService) { 
    this.dxHost = this.configService.dxHost; 
    this.apiUrl = `${this.dxHost}/wps/poc?page=ibm.portal.caas.page&mime-type=application/json&urile=wcm:path:/woodburn%20healthcare%20design/json/articles.json`;
  }

  getArticles(): Observable<any> {

   return this.http.get<any>(this.apiUrl);

  }

  getArticle(contentId: string): Observable<any> {
   const url = `${this.dxHost}/wps/contenthandler/wcmrest-v2/contents/${contentId}`;
    return this.http.get<any>(url);
  }
}
*/